"""
graph_utils
===========

This subpackage provides tools for constructing weighted k‑nearest neighbor graphs,
computing self‑tuning bandwidths, and symmetrizing directed graphs.  It is used
internally by the Diffusion‑Aligned Embeddings (DAE) algorithm.

The main entry point is :func:`build_weighted_graph` which orchestrates kNN
search, sigma estimation and symmetrization.  See the module docstring in
``graph_builder.py`` for details.
"""

from .graph_builder import build_weighted_graph  # noqa: F401
from .kernels import default_kernel, DEFAULT_KERNEL_DEFAULT_PARAMS, make_builtin_kernel, builtin_kernel_names  # noqa: F401
from .knn_backends import fast_knn_search, available_knn_backends  # noqa: F401
from .metrics import resolve as resolve_metric, register_metric, MetricSpec  # noqa: F401
from .symmetrize import symmetrize_graph  # noqa: F401
from .weights import compute_weights_vectorized, sigma_eff  # noqa: F401

__all__ = [
    "build_weighted_graph",
    "default_kernel",
    "DEFAULT_KERNEL_DEFAULT_PARAMS",
    "make_builtin_kernel",
    "builtin_kernel_names",
    "fast_knn_search",
    "available_knn_backends",
    "resolve_metric",
    "register_metric",
    "MetricSpec",
    "symmetrize_graph",
    "compute_weights_vectorized",
    "sigma_eff",
]